#pragma once
/*=======================================================================
Ladybug Technologies LLC , All Rights Reserved
Copy Right August 2008
Author: Jon Sigler
Date: August 2008
Version: 1.0.0
-----------------------------------------------------------------------*/


#ifdef LB_API2_EXPORTS
#define LB_API2 __declspec(dllexport) long __stdcall
#else
#define LB_API2 __declspec(dllimport) long __stdcall
#endif

enum MEAS_MODE 
{
	MM_UNK = 0,
	MM_CW = 1,
	MM_CW_PF = 2,
	MM_PULSE = 3,							// standard statistical pulse measurements
	MM_PULSE_PF = 4							// pulse profiling
};

enum MODEL_NUMBER							// Enumeration of model numbers
{
	MNUknwn = -1,
	LB4xxA  = 0,
	LB478A	= 1,
	LB479A	= 2,
	LB480A	= 3,
	LB559A  = 4,							// 12.5GHz CW Sensor
	LB579A  = 5,							// 18.0GHz CW Sensor
	LB589A  = 6,							// 26.0GHz CW Sensor
	GUknwn = -1,
	GOEMOEM = 64,
	GUnSet = 65,							// Required for accounting purposes
	GT8888A = 66,							// GT-8888A = LB478A  10 MHz to 10 GHz  CW
	GT8551A = 67,							// GT-8551A = LB479A  10 MHz to 10 GHz  CW and Modulation
	GT8552A = 68,							// GT-8552A = LB480A  100 MHz to 10 GHz  CW and Pulse Profiling
	GT8553A = 69,							// GT-8553A = LB579A  10 MHz to 18 GHz  CW
	GT8554A = 70,							// GT-8554A = LB589A  10 MHz to 26.5 GHz  CW
};

enum TRIGGER_EDGE
{
	POSITIVE = 0,
	NEGATIVE = 1
};

enum TRIGGER_SOURCE
{
	INT_AUTO_LEVEL = 0, 
	INTERNAL = 1,
	EXTERNAL = 2
};

enum TRIGGER_OUT_MODE
{
	TRG_OUT_DISABLED = 0, 
	TRG_OUT_ENABLED_NON_INV = 1,
	TRG_OUT_ENABLED_INV = 2
};

enum MARKER_MODE
{
	MKR_OFF = 0,
	NORMAL_MKR = 1,
	DELTA_MKR = 2
};

enum GATE_MODE
{
    GATE_OFF = 0,
	GATE_ON = 1
};

enum AVG_MODE
{
	AVG_OFF = 0, 
	AVG_AUTO_RESET = 1,
	AVG_MANUAL_RESET = 2,
};

enum PWR_UNITS
{
	DBM		= 0,						// dBm
	DBW		= 1,						// dBW
	DBKW	= 2,						// dBkW
	DBUV	= 3,						// dBuV
	DBMV    = 4,						// dBmV
	DBV     = 5,						// dBV
	W		= 6,						// Watts
	V		= 7,						// Volts
	DBREL	= 8							// dB Relative
	//W		= 4,						// Watts
	//V		= 5,						// Volts
	//DBREL	= 6							// dB Relative
};

enum FEATURE_STATE
{
	OFF		= 0,						
	ON		= 1
};

enum LIMIT_STYLE						// Enumeration of pass/fail limits
{
	LIMITS_OFF	 = 0,						
	SINGLE_SIDED = 1,
	DOUBLE_SIDED = 2
};

enum SS_RULE
{
	PASS_LT				= 0,			// Pass if measured value less than 
	PASS_LTE			= 1,			// Pass if measured value less than or equal 
	PASS_GT				= 2,			// Pass if measured value greater than 
	PASS_GTE			= 3,			// Pass if measured value greater than or equal
};

enum DS_RULE
{
	PASS_BETWEEN_EXC	= 0,			// Pass if measured value is greater than the lower limit and less than the upper limit
	PASS_BETWEEN_INC	= 1,			// Pass if measured value is equal to or greater than the lower limit and equal to or less than the upper limit
	PASS_OUTSIDE_EXC	= 2,			// Pass if measured value is less than the lower limit OR greater than the upper limit
	PASS_OUTSIDE_INC	= 3				// Pass if measured value is equal to or greater than the upper limit OR equal to or less than the lower limit
};

enum PASS_FAIL_RESULT
{
	PASS					= 0,		// pass, measured value within limits
	FAIL_LOW				= 1,		// failed, measured value too low
	FAIL_HIGH				= 2,		// failed, measured value too high
	FAIL_BETWEEN_LIMIT_EXC	= 3,		// failed greater than or equal to lower limit
	FAIL_BETWEEN_LIMIT_INC	= 4,		// failed less than or equal to lower limit
	NO_DETERMINATION		= 5			// no determination made, possible reasons include but are
										// not limited to the following reasons:
										//		- limits are not enabled
										//		- limits are not specified
										//		- valid measurement not made (timeout?)
};

enum RATIO_MATH_OP
{
	A_MINUS_B	= 0,
	B_MINUS_A	= 1,
	A_PLUS_B	= 2,
	B_PLUS_A	= 3,
	A_MULT_B	= 4,
	B_MULT_A	= 5,
	A_DIV_B		= 6,
	B_DIV_A		= 7
};

enum DATA_ACQ_RATE
{
	FR_500KZ = 0,
	FR_250KZ = 1	
};

enum SWEEP_TIME
{	
	INVALID_SWP_TIME	= -1,			// invalid sweep time
	ST_10				= 0,			// 10 USEC
	ST_20				= 1,			// 20 USEC
	ST_50				= 2,			// 50 USEC

	ST_100				= 3,			// 100 USEC
	ST_200				= 4,			// 200 USEC
	ST_500				= 5,			// 500 USEC

	ST_1000				= 6,			// 1000 USEC OR 1 MSEC
	ST_2000				= 7,			// 2000 USEC OR 2 MSEC
	ST_5000				= 8,			// 5000 USEC OR 5 MSEC

	ST_10000			= 9,			// 10000 USEC OR 10 MSEC
	ST_20000			= 10,			// 20000 USEC OR 20 MSEC
	ST_50000			= 11,			// 50000 USEC RO 50 MSEC

	ST_100000			= 12,			// 100000 USEC OR 100 MSEC
	ST_200000			= 13,			// 200000 USEC OR 200 MSEC
	ST_500000			= 14,			// 500000 USEC OR 500 MSEC

	ST_1000000			= 15,			// 1000000 USEC OR 1000 MSEC OR 1 SEC

	SD_1200				= 16,			// 1200 USEC OR 1.2 MSEC DELAYED SWEEP - 96 passes, used with 10usec to 200usec sweep times for delays <= 1 msec
	SD_5200				= 17,			// 5200 USEC OR 5.2 MSEC DELAYED SWEEP - 96 passes, used with 10usec to 200usec sweep times for delays <= 5 msec
	SD_10200			= 18,			// 10200 USEC OR 10.2 MSEC DELAYED SWEEP - 96 passes, used with 10usec to 200usec sweep times for delays <= 10 msec
	SD_10500			= 19,			// 10500 USEC OR 10.5 MSEC DELAYED SWEEP - 48 passes, used with 500usec to sweep times for delays <= 10 msec
	SD_20000			= 20,			// 20000 USEC OR 20.0 MSEC DELAYED SWEEP - 24 passes, used with 1msec to 10msec sweep times for delays <= 10 msec
	SD_30000			= 21,			// 30000 USEC OR 30.0 MSEC DELAYED SWEEP - 12 passes, used with 20msec sweep times for delays <= 10 msec
	SD_60000			= 22,			// 60000 USEC OR 60.0 MSEC DELAYED SWEEP - 6 passes, used with 50msec sweep times for delays <= 10 msec
};

enum TR_DIAG 
{
	TR_NORMAL = 0,
	TR_LOSENSE = 1,
	TR_HISENSE = 2
};

enum FLT_POLES
{
	ONE_POLE = 0,
	TWO_POLES = 1,
	FOUR_POLES = 2
};

enum FLT_CO_FREQ
{
	FLT_UNK  = -1,						// filter unknown
	FLT_DIS  = 0,						// filters disabled
	FLT_100K = 1,						// 100KHz
	FLT_200K = 2,						// 200KHz
	FLT_300K = 3,						// 300KHz
	FLT_500K = 4,						// 500KHz
	FLT_1M = 5,							// 1MHz
	FLT_2M = 6,							// 2MHz
	FLT_3M = 7,							// 3MHz
	FLT_5M = 8,							// 5MHz
	FLT_MAX = 9
};

// ********************* Matt's changes

typedef struct 									// structure used to create freqeuncy sensitive offsets or 
{										// compensate for frequency response
	double frequency;					// Hz
	double amplitude;					// dB
} ResponsePoints;

typedef struct 
{
	long DeviceIndex;					// 1..n
	long DeviceAddress;					// 1..255
	char SerialNumber[8];		// zero terminated string, 6 characters and a null ... make it eight for alignment purposes
} SensorDescrption;


typedef struct 
{
	long trIdx;										// index where peak was found
	double value;									// value of peak
} Peak;


// ********************  End Matt's changes


LB_API2 LB_AddressConflictExists(void);
LB_API2 LB_BlinkLED_Addr(long addr);
LB_API2 LB_BlinkLED_SN(char* SN);
LB_API2 LB_BlinkLED_Idx(long index);
LB_API2 LB_ChangeAddress(long currentAddr, long newAddr);
LB_API2 LB_DriverVersion(void);
LB_API2 LB_GetAddress_Idx(long idx);
LB_API2 LB_GetAddress_SN(char* SN);

LB_API2 LB_GetAntiAliasingEnabled(long addr, long* st);
// LB_API2 LB_GetAntiAliasingEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_GetAutoPulseEnabled(long addr, long* st);
// LB_API2 LB_GetAutoPulseEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_GetAverages(long addr, long* value);
LB_API2 LB_GetBestMatchOpt(char* SN, long* val);
LB_API2 LB_GetCalAndWtyOption(char* SN, long* val);
LB_API2 LB_GetCalDueDate(char* SN, long* year, long* month, long* day);
LB_API2 LB_GetCalOptExpDate(char* SN, long* year, long* month, long* day);
LB_API2 LB_GetConnectorOption(char* SN, long* val);

LB_API2 LB_GetCWReference(long addr, double* relRef, long* units);
//LB_API2 LB_GetCWReference(long addr, double* relRef, PWR_UNITS* units);

LB_API2 LB_GetDoubleSidedLimit(long addr, double* lowerVal, double* upperVal, long* units, long* passFail);
//LB_API2 LB_GetDoubleSidedLimit(long addr, double* lowerVal, double* upperVal, PWR_UNITS* units, DS_RULE* passFail);

LB_API2 LB_GetDutyCycleEnabled(long addr, long* st);
//LB_API2 LB_GetDutyCycleEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_GetDutyCyclePerCent(long addr, double* val);
LB_API2 LB_GetFilterOpt(char* SN, long* val);
LB_API2 LB_GetFirmwareVersion(long addr, char* buff, long buffLen);
LB_API2 LB_GetFrequency(long addr, double* value);
LB_API2 LB_GetIndex_Addr(long addr);
LB_API2 LB_GetIndex_SN(char* SN);

LB_API2 LB_GetLimitEnabled(long addr, long* lmtStyle);
//LB_API2 LB_GetLimitEnabled(long addr, LIMIT_STYLE* lmtStyle);

LB_API2 LB_GetMeasurementPowerUnits(long addr,long* units);
//LB_API2 LB_GetMeasurementPowerUnits(long addr,PWR_UNITS* units);

LB_API2 LB_GetModelNumber_Addr(long addr, long* modelNumber);	//  See below
LB_API2 LB_GetModelNumber_Idx(long idx, long* modelNumber);	//  See below		
LB_API2 LB_GetModelNumber_SN(char* SN, long* modelNumber);  	//  LB_API2 LB_GetModelNumber_SN(char* SN, MODEL_NUMBER* modelNumber);

LB_API2 LB_GetOffset(long addr, double* val);

LB_API2 LB_GetOffsetEnabled(long addr, long* st);
//LB_API2 LB_GetOffsetEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_GetPulseCriteria(long addr, double* value);

LB_API2 LB_GetPulseReference(long addr, double* pulseRef, double* peakRef, double* averageRef, double* dutyCycleRef, long* units);
//LB_API2 LB_GetPulseReference(long addr, double* pulseRef, double* peakRef, double* averageRef, double* dutyCycleRef, PWR_UNITS* units);

LB_API2 LB_GetRecorderOutEnabled(long addr, long* st);
//LB_API2 LB_GetRecorderOutEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_GetRecorderOutOption(char* SN, long* val);

LB_API2 LB_GetRecorderOutSetup(long addr, double* val_0_V, double* val_1_V, long* units);
//LB_API2 LB_GetRecorderOutSetup(long addr, double* val_0_V, double* val_1_V, PWR_UNITS* units);

LB_API2 LB_GetResponse(long addr, ResponsePoints* pts, long* NumPts);

LB_API2 LB_GetResponseEnabled(long addr, long* st);
//LB_API2 LB_GetResponseEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_GetSerNo_Addr(long addr, char* SN);
LB_API2 LB_GetSerNo_Idx(long idx, char* SN);

LB_API2 LB_GetSingleSidedLimit(long addr, double* val, long* units, long* passFail);
//LB_API2 LB_GetSingleSidedLimit(long addr, double* val, PWR_UNITS* units, SS_RULE* passFail);

LB_API2 LB_GetTriggerOpt(char* SN, long* val);

LB_API2 LB_GetTTLTriggerInEnabled(long addr, long* st);
//LB_API2 LB_GetTTLTriggerInEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_GetTTLTriggerInInverted(long addr, long* st);
//LB_API2 LB_GetTTLTriggerInInverted(long addr, FEATURE_STATE* st);

LB_API2 LB_GetTTLTriggerInTimeOut(long addr, long* val);

LB_API2 LB_GetTTLTriggerOutEnabled(long addr, long* st);
//LB_API2 LB_GetTTLTriggerOutEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_GetTTLTriggerOutInverted(long addr, long *st);
//LB_API2 LB_GetTTLTriggerOutInverted(long addr, FEATURE_STATE *st);

LB_API2 LB_GetWtyOptExpDate(char* SN, long* year, long* month, long* day);
LB_API2 LB_InitializeSensor_Addr(long addr);
LB_API2 LB_InitializeSensor_Idx(long idx);
LB_API2 LB_InitializeSensor_SN(char* SN);
LB_API2 LB_UninitializeSensor_SN(char* SN);
LB_API2 LB_IsSensorConnected_Addr(long addr);
LB_API2 LB_IsSensorConnected_SN(char* SN);
LB_API2 LB_MeasureCW(long addr, double* CW);

LB_API2 LB_MeasureCW_PF(long addr, double* CW, long* PF);
//LB_API2 LB_MeasureCW_PF(long addr, double* CW, PASS_FAIL_RESULT* PF);

LB_API2 LB_MeasurePulse(long addr, double* pulse, double* peak, double* average, double* dutyCycle);

LB_API2 LB_MeasurePulse_PF(long addr, double* pulse, double* peak, double* average, double* dutyCycle, long* PF);
//LB_API2 LB_MeasurePulse_PF(long addr, double* pulse, double* peak, double* average, double* dutyCycle, PASS_FAIL_RESULT* PF);

LB_API2 LB_ReadStateFromINI(long addr);
LB_API2 LB_Recall(long addr, long regIdx);
LB_API2 LB_ResetCurrentState(long addr);
LB_API2 LB_ResetRegStates(long addr);
LB_API2 LB_SensorCnt(void);
LB_API2 LB_SensorList(SensorDescrption* SD, long cnt);
LB_API2 LB_SetAddress_Idx(long idx, long addr);
LB_API2 LB_SetAddress_SN(char* SN, long addr);

LB_API2 LB_SetAntiAliasingEnabled(long addr, long st);
//LB_API2 LB_SetAntiAliasingEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_SetAutoPulseEnabled(long addr, long st);
//LB_API2 LB_SetAutoPulseEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_SetAverages(long addr, long value);
LB_API2 LB_SetBestMatchOpt(char* SN, long PW, long optVal);
LB_API2 LB_SetCalAndWtyOption(char* SN, long PW, long optVal);
LB_API2 LB_SetCalDueDate(char* SN, long lngYear, long lngMonth, long lngDay);
LB_API2 LB_SetCalOptExpDate(char* SN, long PW, long lngYear, long lngMonth, long lngDay);
LB_API2 LB_SetConnectorOption(char* SN, long PW, long optVal);

LB_API2 LB_SetCWReference(long addr, double relRef, long units);
//LB_API2 LB_SetCWReference(long addr, double relRef, PWR_UNITS units);

LB_API2 LB_SetDoubleSidedLimit(long addr, double lowerVal, double upperVal, long units, long passFail);
//LB_API2 LB_SetDoubleSidedLimit(long addr, double lowerVal, double upperVal, PWR_UNITS units, DS_RULE passFail);

LB_API2 LB_SetDutyCycleEnabled(long addr, long st);
//LB_API2 LB_SetDutyCycleEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_SetDutyCyclePerCent(long addr, double val);
LB_API2 LB_SetFilterOpt(char* SN, long PW, long optVal);
LB_API2 LB_SetFrequency(long addr, double value);

LB_API2 LB_SetLimitEnabled(long addr, long lmtStyle);
//LB_API2 LB_SetLimitEnabled(long addr, LIMIT_STYLE lmtStyle);

LB_API2 LB_SetMeasurementPowerUnits(long addr,long units);
//LB_API2 LB_SetMeasurementPowerUnits(long addr,PWR_UNITS units);

LB_API2 LB_SetModelNumber(char* SN, long PW, long modelNumber);
//LB_API2 LB_SetModelNumber(char* SN, long PW, MODEL_NUMBER modelNumber);

LB_API2 LB_SetOffset(long addr, double val);

LB_API2 LB_SetOffsetEnabled(long addr, long st);
//LB_API2 LB_SetOffsetEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_SetPulseCriteria(long addr, double value);

LB_API2 LB_SetPulseReference(long addr,double pulseRef, double peakRef, double averageRef, double dutyCycleRef, long units);
//LB_API2 LB_SetPulseReference(long addr,double pulseRef, double peakRef, double averageRef, double dutyCycleRef, PWR_UNITS units);

LB_API2 LB_SetRecorderOutEnabled(long addr, long st);
//LB_API2 LB_SetRecorderOutEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_SetRecorderOutOption(char* SN, long PW, long optVal);

LB_API2 LB_SetRecorderOutSetup(long addr, double val_0_V, double val_1_V, long units);
//LB_API2 LB_SetRecorderOutSetup(long addr, double val_0_V, double val_1_V, PWR_UNITS units);

LB_API2 LB_SetResponse(long addr, ResponsePoints* pts, long NumPts);

LB_API2 LB_SetResponseEnabled(long addr, long st);
//LB_API2 LB_SetResponseEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_SetSerialNumber(long idx, long PW, char* SN);

LB_API2 LB_SetSingleSidedLimit(long addr, double val, long units, long passFail);
//LB_API2 LB_SetSingleSidedLimit(long addr, double val, PWR_UNITS units, SS_RULE passFail);

LB_API2 LB_SetSysTimeOut(long newTimeout);
LB_API2 LB_SetTriggerOpt(char* SN, long PW, long optVal);

LB_API2 LB_SetTTLTriggerInEnabled(long addr, long st);
//LB_API2 LB_SetTTLTriggerInEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_SetTTLTriggerInInverted(long addr, long st);
//LB_API2 LB_SetTTLTriggerInInverted(long addr, FEATURE_STATE st);

LB_API2 LB_SetTTLTriggerInTimeOut(long addr, long val);

LB_API2 LB_SetTTLTriggerOutEnabled(long addr, long st);
//LB_API2 LB_SetTTLTriggerOutEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_SetTTLTriggerOutInverted(long addr, long st);
//LB_API2 LB_SetTTLTriggerOutInverted(long addr, FEATURE_STATE st);

LB_API2 LB_SetWtyOptExpDate(char* SN, long PW, long lngYear, long lngMonth, long lngDay);
LB_API2 LB_Store(long addr, long regIdx);
LB_API2 LB_WillAddressConflict(long addr);
LB_API2 LB_WriteStateToINI(long addr);
LB_API2 PP_AcquireTrace(long addr);
LB_API2 PP_CheckTrigger(long addr);
LB_API2 PP_CnvtTrace(long addr, double* trIn, long trLen, double* trOut, long pwrUnitsIn, long pwrUnitsOut);
LB_API2 PP_CurrTrace2AnalysisTrace(long addr, double*tr, long trLen);
LB_API2 PP_GatePositionIsValid(long addr, long gateIdx, long* valid);

LB_API2 PP_GetAvgMode(long addr, long *mode);
//LB_API2 PP_GetAvgMode(long addr, AVG_MODE *mode);

LB_API2 PP_GetAvgResetSens(long addr, double* sensitivity);

LB_API2 PP_GetFilter(long addr, long* fltrIdx);
//LB_API2 PP_GetFilter(long addr, FLT_CO_FREQ* fltrIdx);

LB_API2 PP_GetGateAveragePower(long addr, long gateIdx, double* avgPwr);
LB_API2 PP_GetGateCrestFactor(long addr, long gateIdx, double* crFactor);
LB_API2 PP_GetGateDroop(long addr, long gateIdx, double* droop);
LB_API2 PP_GetGateDutyCycle(long addr, long gateIdx, double* dutyCycle);
LB_API2 PP_GetGateEndPosition(long addr, long gateIdx, long* trIdx);
LB_API2 PP_GetGateEndTime(long addr, long gateIdx, double* gateTm);
LB_API2 PP_GetGateFallTime(long addr, long gateIdx, double* fallTm);

LB_API2 PP_GetGateMode(long addr, long gateIdx, long* mode);
//LB_API2 PP_GetGateMode(long addr, long gateIdx, GATE_MODE * mode);

LB_API2 PP_GetGateOverShoot(long addr, long gateIdx, double* overShoot);
LB_API2 PP_GetGatePeakPower(long addr, long gateIdx, double* pkPwr);
LB_API2 PP_GetGatePRF(long addr, long gateIdx, double* PRFreq);
LB_API2 PP_GetGatePRT(long addr, long gateIdx, double* PRTime);
LB_API2 PP_GetGatePulseWidth(long addr, long gateIdx, double* plsWidth);
LB_API2 PP_GetGatePulsePower(long addr, long gateIdx, double* plsPwr);
LB_API2 PP_GetGateRiseTime(long addr, long gateIdx, double* riseTm);
LB_API2 PP_GetGateStartEndPosition(long addr, long gateIdx, long* trSttIdx, long* trEndIdx);
LB_API2 PP_GetGateStartEndPositionTime(long addr, long gateIdx, long* sttIdx, double* sttTm, long* endIdx, double* endTm);
LB_API2 PP_GetGateStartEndTime(long addr, long gateIdx, double* gateSttTm, double* gateEndTm);
LB_API2 PP_GetGateStartPosition(long addr, long gateIdx, long* trIdx);
LB_API2 PP_GetGateStartTime(long addr, long gateIdx, double* gateTm);
LB_API2 PP_GetMarkerAmp(long addr, long mrkIdx, double* mkrAmp);
LB_API2 PP_GetMarkerDeltaAmp(long addr, long mrkIdx, double* deltaMkrAmp);
LB_API2 PP_GetMarkerDeltaTime(long addr, long mrkIdx, double* mkrTm);

LB_API2 PP_GetMarkerMode(long addr, long mrkIdx, long* mode);
//LB_API2 PP_GetMarkerMode(long addr, long mrkIdx, MARKER_MODE * mode);

LB_API2 PP_GetMarkerPosition(long addr, long mrkIdx, long* trIdx);
LB_API2 PP_GetMarkerPositionTime(long addr, long mrkIdx, double* mkrTm);
LB_API2 PP_GetMeasurementThreshold(long addr, double* measThreshold_dBm);
LB_API2 PP_GetPeaks_Idx(long addr,Peak* peaks,long maxPks,long* pksUsed);
LB_API2 PP_GetPeaks_Val(long addr, Peak* peaks, long maxPks,long* pksUsed);
LB_API2 PP_GetPeaksFromTr_Idx(double* tr,long trLen, long units, double peakCrit, double measThresh, Peak* peaks, long maxPks, long* pksUsed);
LB_API2 PP_GetPeaksFromTr_Val(double* tr, long trLen, long units, double peakCrit, double measThresh, Peak* peaks, long maxPks, long* pksUsed);

LB_API2 PP_GetPoles(long addr, long* fltrPoles);
//LB_API2 PP_GetPoles(long addr, FLT_POLES* fltrPoles);

LB_API2 PP_GetSweepDelay(long addr, long* SwpDly);
LB_API2 PP_GetSweepDelayMode(long addr, long* SwpDlyMode);
LB_API2 PP_GetSweepHoldOff(long addr, long* SwpHOff);
LB_API2 PP_GetSweepTime(long addr, long* SwpTm);
LB_API2 PP_GetTrace(long addr, double *tr, long trLen, long* trUsed);
LB_API2 PP_GetTraceAvgPower(long addr, double* avgPwr);
LB_API2 PP_GetTraceAvgs(long addr, long*averages);
LB_API2 PP_GetTraceCCDF(long addr, double* trCCDF, long trLen);
LB_API2 PP_GetTraceCDF(long addr, double* trCDF, long trLen);
LB_API2 PP_GetTraceCrestFactor(long addr, double* CrF);
LB_API2 PP_GetTraceDC(long addr, double* dutyCycle);
LB_API2 PP_GetTraceLength(long addr);
LB_API2 PP_GetAnalysisTraceLength(long addr);
LB_API2 PP_GetTracePkPwr(long addr, double* pkPwr);
LB_API2 PP_GetTracePulsePower(long addr, double* plsPwr);
LB_API2 PP_GetTracePwrDensity(long addr, double* trPD, long trLen);

LB_API2 PP_GetTriggerEdge(long addr, long* TrgEdge);
//LB_API2 PP_GetTriggerEdge(long addr, TRIGGER_EDGE* TrgEdge);

LB_API2 PP_GetTriggerLevel(long addr, double* TrgLvl);

LB_API2 PP_GetTriggerOut(long addr, long* trgOutMode);
//LB_API2 PP_GetTriggerOut(long addr, TRIGGER_OUT_MODE *trgOutMode);

LB_API2 PP_GetTriggerSoure(long addr, long* TrgSrc);
//LB_API2 PP_GetTriggerSoure(long addr, TRIGGER_SOURCE* TrgSrc);

LB_API2 PP_MarkerNextPk(long addr, long mrkIdx);
LB_API2 PP_MarkerPkHigher(long addr, long mrkIdx);
LB_API2 PP_MarkerPkLower(long addr, long mrkIdx);
LB_API2 PP_MarkerPosIsValid(long addr, long mrkIdx, long* valid);
LB_API2 PP_MarkerPrevPk(long addr, long mrkIdx);
LB_API2 PP_MarkerToFirstPk(long addr, long mrkIdx);
LB_API2 PP_MarkerToLastPk(long addr, long mrkIdx);
LB_API2 PP_MarkerToLowestPk(long addr, long mrkIdx);
LB_API2 PP_MarkerToPk(long addr, long mrkIdx);
LB_API2 PP_ResendState(long addr);
LB_API2 PP_ResetTraceAveraging(long addr);

LB_API2 PP_SetAnalysisTrace(long addr, double frequency, double sweepTime, double*tr, long trLen, long units);
//LB_API2 PP_SetAnalysisTrace(long addr, double frequency, double sweepTime, double*tr, long trLen, PWR_UNITS units);

LB_API2 PP_SetAvgMode(long addr, long mode);
//LB_API2 PP_SetAvgMode(long addr, AVG_MODE mode);

LB_API2 PP_SetAvgResetSens(long addr, double sensitivity);
LB_API2 PP_SetClosestSweepTimeUSEC(long  addr, long  swpTm);

LB_API2 PP_SetFilter(long addr, long fltrIdx);
//LB_API2 PP_SetFilter(long addr, FLT_CO_FREQ fltrIdx);

LB_API2 PP_SetGateEndPosition(long addr, long gateIdx, long trIdx);
LB_API2 PP_SetGateEndTime(long addr, long gateIdx, double gateTm);

LB_API2 PP_SetGateMode(long addr, long gateIdx, long mode);
//LB_API2 PP_SetGateMode(long addr, long gateIdx, GATE_MODE mode);

LB_API2 PP_SetGateStartEndPosition(long addr, long gateIdx, long trSttIdx, long trEndIdx);
LB_API2 PP_SetGateStartEndTime(long addr, long gateIdx, double gateSttTm, double gateEndTm);
LB_API2 PP_SetGateStartPosition(long addr, long gateIdx, long trIdx);
LB_API2 PP_SetGateStartTime(long addr, long gateIdx, double gateTm);
LB_API2 PP_SetMarkerDeltaTime(long addr, long mrkIdx, double mkrTm);

LB_API2 PP_SetMarkerMode(long addr, long mrkIdx, long mode);
//LB_API2 PP_SetMarkerMode(long addr, long mrkIdx, MARKER_MODE mode);

LB_API2 PP_SetMarkerPosition(long addr, long mrkIdx, long trIdx);
LB_API2 PP_SetMarkerPositionTime(long addr, long mrkIdx, double mkrTm);
LB_API2 PP_SetMeasurementThreshold(long addr, double measThreshold_dBm);

LB_API2 PP_SetPoles(long addr, long fltrPoles);
//LB_API2 PP_SetPoles(long addr, FLT_POLES fltrPoles);

LB_API2 PP_SetState(long addr);
LB_API2 PP_SetSweepDelay(long addr, long SwpDly);
LB_API2 PP_SetSweepDelayMode(long addr, long SwpDlyMode);
LB_API2 PP_SetSweepHoldOff(long addr, long SwpHOff);
LB_API2 PP_SetSweepTime(long addr, long SwpTm);
LB_API2 PP_SetTraceAvgs(long addr, long averages);

LB_API2 PP_SetTriggerEdge(long addr, long TrgEdge);
//LB_API2 PP_SetTriggerEdge(long addr, TRIGGER_EDGE TrgEdge);

LB_API2 PP_SetTriggerLevel(long addr, double TrgLvl);

LB_API2 PP_SetTriggerOut(long addr, long trgOutMode);
//LB_API2 PP_SetTriggerOut(long addr, TRIGGER_OUT_MODE trgOutMode);

LB_API2 PP_SetTriggerSoure(long addr, long TrgSrc);
//LB_API2 PP_SetTriggerSoure(long addr, TRIGGER_SOURCE TrgSrc);

LB_API2 PP_TakeSweep(long addr);

// NEW
LB_API2 LB_DiagCW(long Addr, 
				  long Frames, 
				  double *LSTemp, 
				  double *LSTempDev, 
				  double *LSPwr , 
				  double *LSPwrDev, 
				  double *LSdBm,
				  double *LSdBDev,
				  double *HSTemp, 
				  double *HSTempDev, 
				  double *HSPwr, 
				  double *HSPwrDev,
				  double *HSdBm, 
				  double *HSdBDev);
LB_API2 LB_DiagStoreCoeff(long Addr);
LB_API2 LB_DiagGetRawBuff(long Addr, 
						  double *LSTmps, 
						  double *LSPwr, 
						  double *HSTmps, 
						  double *HSPwr);

LB_API2 LB_GetExtendedAveragingEnabled(long addr, long* st);
//LB_API2 LB_GetExtendedAveragingEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_SetExtendedAveragingEnabled(long addr, long st);
//LB_API2 LB_SetExtendedAveragingEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_GetExtendedAveraging(long addr, long* extAvg);
LB_API2 LB_SetExtendedAveraging(long addr, long extAvg);
LB_API2 LB_ResetExtendedAveraging(long addr);

LB_API2 LB_GetMaxHoldEnabled(long addr, long* st);
//LB_API2 LB_GetMaxHoldEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_SetMaxHoldEnabled(long addr, long st);
//LB_API2 LB_SetMaxHoldEnabled(long addr, FEATURE_STATE st);

LB_API2 LB_ResetMaxHold(long addr);

LB_API2 LB_Get75OhmsEnabled(long addr, long* st);
//LB_API2 LB_Get75OhmsEnabled(long addr, FEATURE_STATE* st);

LB_API2 LB_Set75OhmsEnabled(long addr, long st);
//LB_API2 LB_Set75OhmsEnabled(long addr, FEATURE_STATE st);

LB_API2 PP_GetPulseEdgesPosition(long addr, long pkIdx, long* leftTrIdx, long* rightTrIdx);
LB_API2 PP_GetPulseEdgesTime(long addr, double pkTime, double* leftSide, double* rightSide);
LB_API2 PP_AnalysisTraceIsValid(long  addr);
LB_API2 LB_DiagGetLinAvgOfNBuff(long Idx, 
						  long N,
						  double *LST, 
						  double *LSP, 
						  double *HST, 
						  double *HSP);
LB_API2 DIAG_AttachCnt();							
LB_API2 LB_IsDeviceInUse_Idx(long idx);
LB_API2 LB_IsDeviceInUse_Addr(long addr);
LB_API2 LB_IsDeviceInUse_SN(char* SN);

LB_API2 LB_SaveCurrStateTo(long addr, char* stateName);
LB_API2 LB_RestoreCurrStateFrom(long addr, char* stateName);

LB_API2 LB_GetNamedStateCount(long addr);
LB_API2 LB_GetNamedStateNames(long addr, char* names, long *cnt);
LB_API2 LB_DeleteNamedState(long addr, char* name);
